/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.tbk.ngtor.NgtorApplicationWebMvcConfigurer;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableWebMvc
@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
class NgtorApplicationWebMvcConfigurer
implements WebMvcConfigurer {
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/resources/", "classpath:/resources/", "classpath:/static/", "classpath:/public/"};

    NgtorApplicationWebMvcConfigurer() {
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(CLASSPATH_RESOURCE_LOCATIONS);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "index.html");
    }

    @SuppressFBWarnings(value={"PERMISSIVE_CORS"})
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"});
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        NgtorApplicationWebMvcConfigurer.customizeJacksonMessageConverter(converters);
    }

    private static void customizeJacksonMessageConverter(List<HttpMessageConverter<?>> converters) {
        converters.stream().filter(any -> any instanceof MappingJackson2HttpMessageConverter).map(any -> (MappingJackson2HttpMessageConverter)any).forEach(converter -> NgtorApplicationWebMvcConfigurer.configureObjectMapper((ObjectMapper)converter.getObjectMapper()));
    }

    private static void configureObjectMapper(ObjectMapper objectMapper) {
        SimpleModule internalModule = new SimpleModule("AppInternal").addSerializer((JsonSerializer)new BigDecimalToStringSerializer());
        objectMapper.registerModule((Module)internalModule).setSerializationInclusion(JsonInclude.Include.NON_NULL).enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).enable(SerializationFeature.INDENT_OUTPUT).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN}).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

