/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor.command;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.ngtor.conditional.ConditionalOnCommand;
import org.tbk.tor.hs.HiddenServiceDefinition;
import org.tbk.tor.spring.config.TorAutoConfigProperties;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCommand(value={"http"})
public class HttpCommandConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpCommandConfig.class);
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_IDENTITY = "ngtor_main";

    @Bean
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path is controlled by operator not by user input.")
    public HiddenServiceDefinition hiddenServiceDefinition(ApplicationArguments args, TorAutoConfigProperties torProperties) {
        int port = Optional.ofNullable(args.getOptionValues("port")).flatMap(it -> it.stream().findFirst()).map(Integer::parseUnsignedInt).orElse(8080);
        String identity = DEFAULT_IDENTITY;
        System.out.printf("Setting up hidden service '%s' for port %d%n", identity, port);
        Path hiddenServiceDir = Paths.get(torProperties.getWorkingDirectory(), new String[0]).resolve(identity);
        return HiddenServiceDefinition.builder().directory(hiddenServiceDir.toFile()).virtualPort(Integer.valueOf(80)).port(Integer.valueOf(port)).host(InetAddress.getLoopbackAddress().getHostAddress()).build();
    }
}

