/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor.conditional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;
import org.tbk.ngtor.conditional.ConditionalOnCommand;
import org.tbk.ngtor.conditional.OnCommandCondition;

@Order(value=-2126483648)
class OnCommandCondition
extends SpringBootCondition {
    OnCommandCondition() {
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="False positive. Should throw on unexpected null values!")
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap multiValueMap = Objects.requireNonNull(metadata.getAllAnnotationAttributes(ConditionalOnCommand.class.getName()));
        List allAnnotationAttributes = this.annotationAttributesFromMultiValueMap(multiValueMap);
        ArrayList noMatch = new ArrayList();
        ArrayList<ConditionMessage> match = new ArrayList<ConditionMessage>();
        BeanFactory beanFactory = (BeanFactory)Objects.requireNonNull(context.getBeanFactory());
        ApplicationArguments args = Objects.requireNonNull((ApplicationArguments)beanFactory.getBean(ApplicationArguments.class));
        for (AnnotationAttributes annotationAttributes : allAnnotationAttributes) {
            ConditionOutcome outcome = this.determineOutcome(annotationAttributes, args);
            (outcome.isMatch() ? match : noMatch).add(outcome.getConditionMessage());
        }
        if (!noMatch.isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.of(noMatch));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.of(match));
    }

    private List<AnnotationAttributes> annotationAttributesFromMultiValueMap(MultiValueMap<String, Object> multiValueMap) {
        ArrayList maps = new ArrayList();
        multiValueMap.forEach((key, value) -> {
            for (int i = 0; i < value.size(); ++i) {
                Map map;
                if (i < maps.size()) {
                    map = (Map)maps.get(i);
                } else {
                    map = new HashMap();
                    maps.add(map);
                }
                map.put((String)key, value.get(i));
            }
        });
        ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>(maps.size());
        for (Map map : maps) {
            annotationAttributes.add(AnnotationAttributes.fromMap((Map)map));
        }
        return annotationAttributes;
    }

    private ConditionOutcome determineOutcome(AnnotationAttributes annotationAttributes, ApplicationArguments resolver) {
        Spec spec = new Spec(annotationAttributes);
        ArrayList missingProperties = new ArrayList();
        spec.collectProperties(resolver, missingProperties);
        if (!missingProperties.isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnCommand.class, (Object[])new Object[]{spec}).didNotFind("command", "commands").items(ConditionMessage.Style.QUOTE, missingProperties));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnCommand.class, (Object[])new Object[]{spec}).because("matched"));
    }
}

