/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
class NgtorApplicationConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(NgtorApplicationConfig.class);
    @Value(value="${app.home}")
    private String homeDir;

    NgtorApplicationConfig() {
    }

    public void afterPropertiesSet() throws IOException {
        this.checkAppHomeDirectory();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path is controlled by operator not by user input.")
    private void checkAppHomeDirectory() throws IOException {
        log.debug("Checking home directory '{}'", (Object)this.homeDir);
        File dir = Files.createDirectories(Paths.get(this.homeDir, new String[0]), new FileAttribute[0]).toFile();
        if (!dir.exists()) {
            throw new IllegalStateException("App home directory does not exist and could not be created");
        }
        if (!dir.canRead()) {
            throw new IllegalStateException("Cannot read from app home directory. Please check file privileges on " + this.homeDir);
        }
        if (!dir.canWrite()) {
            throw new IllegalStateException("Cannot write to app home directory. Please check file privileges on " + this.homeDir);
        }
    }
}

