/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor.command;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.tbk.ngtor.conditional.ConditionalOnCommand;
import org.tbk.ngtor.tor.TorHttpCheck;
import org.tbk.ngtor.util.ConsoleColors;

@Component
@ConditionalOnCommand(value={"check"})
public class CheckCommand
implements ApplicationRunner {
    @Autowired
    @Qualifier(value="torHttpClient")
    private HttpClient torHttpClient;

    public void run(ApplicationArguments args) {
        System.out.println("Check started..");
        Stopwatch sw = Stopwatch.createStarted();
        try {
            boolean torEnabled = new TorHttpCheck(this.torHttpClient).check();
            if (torEnabled) {
                System.out.println(ConsoleColors.green("\u2714") + " Tor " + ConsoleColors.bold("is working") + ".");
            } else {
                System.out.println(ConsoleColors.red("\u2718") + " Tor is " + ConsoleColors.bold("NOT") + "working correctly.");
            }
            System.out.println("Check finished after " + sw.stop());
        }
        catch (IOException e) {
            System.err.println("Exception during tor http check: " + e.getMessage());
        }
    }
}

