// Generated by delombok at Thu Jan 25 18:54:13 EST 2024
package org.tbk.ngtor.command;

import lombok.NonNull;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.tbk.tor.hs.HiddenServiceDefinition;
import org.tbk.ngtor.conditional.ConditionalOnCommand;
import java.util.Optional;

@Component
@ConditionalOnCommand("demo")
public class DemoCommand implements ApplicationRunner {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DemoCommand.class);
    @NonNull
    private final Tor tor;
    @NonNull
    private final HiddenServiceDefinition hiddenServiceDefinition;

    @Override
    public void run(ApplicationArguments args) {
        Optional<String> httpUrl = hiddenServiceDefinition.getVirtualHost().map(val -> "http://" + val + ":" + hiddenServiceDefinition.getVirtualPort());
        log.info("=================================================");
        log.info("url: {}", httpUrl.orElse("unavailable"));
        log.info("virtual host: {}", hiddenServiceDefinition.getVirtualHost().orElse("unavailable"));
        log.info("virtual port: {}", hiddenServiceDefinition.getVirtualPort());
        log.info("host: {}", hiddenServiceDefinition.getHost());
        log.info("port: {}", hiddenServiceDefinition.getPort());
        log.info("directory: {}", hiddenServiceDefinition.getDirectory().getAbsolutePath());
        httpUrl.ifPresent(url -> {
            log.info("-------------------------------------------------");
            try {
                log.info("Or browse to {} in Tor Browser, or", url);
                log.info("run: `torsocks -p {} curl {}/index.html -v`", tor.getProxy().getPort(), url);
            } catch (TorCtlException e) {
                log.warn("Could not get tor proxy port");
            }
        });
        log.info("=================================================");
    }

    @java.lang.SuppressWarnings("all")
    public DemoCommand(@NonNull final Tor tor, @NonNull final HiddenServiceDefinition hiddenServiceDefinition) {
        if (tor == null) {
            throw new java.lang.IllegalArgumentException("tor is marked non-null but is null");
        }
        if (hiddenServiceDefinition == null) {
            throw new java.lang.IllegalArgumentException("hiddenServiceDefinition is marked non-null but is null");
        }
        this.tor = tor;
        this.hiddenServiceDefinition = hiddenServiceDefinition;
    }
}
