/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor.conditional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.tbk.ngtor.conditional.ConditionalOnCommand;

@Order(value=-2126483648)
class OnCommandCondition
extends SpringBootCondition {
    OnCommandCondition() {
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="False positive. Should throw on unexpected null values!")
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap multiValueMap = Objects.requireNonNull(metadata.getAllAnnotationAttributes(ConditionalOnCommand.class.getName()));
        List<AnnotationAttributes> allAnnotationAttributes = this.annotationAttributesFromMultiValueMap((MultiValueMap<String, Object>)multiValueMap);
        ArrayList noMatch = new ArrayList();
        ArrayList<ConditionMessage> match = new ArrayList<ConditionMessage>();
        BeanFactory beanFactory = (BeanFactory)Objects.requireNonNull(context.getBeanFactory());
        ApplicationArguments args = Objects.requireNonNull((ApplicationArguments)beanFactory.getBean(ApplicationArguments.class));
        for (AnnotationAttributes annotationAttributes : allAnnotationAttributes) {
            ConditionOutcome outcome = this.determineOutcome(annotationAttributes, args);
            (outcome.isMatch() ? match : noMatch).add(outcome.getConditionMessage());
        }
        if (!noMatch.isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.of(noMatch));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.of(match));
    }

    private List<AnnotationAttributes> annotationAttributesFromMultiValueMap(MultiValueMap<String, Object> multiValueMap) {
        ArrayList maps = new ArrayList();
        multiValueMap.forEach((key, value) -> {
            for (int i = 0; i < value.size(); ++i) {
                Map map;
                if (i < maps.size()) {
                    map = (Map)maps.get(i);
                } else {
                    map = new HashMap();
                    maps.add(map);
                }
                map.put((String)key, value.get(i));
            }
        });
        ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>(maps.size());
        for (Map map : maps) {
            annotationAttributes.add(AnnotationAttributes.fromMap((Map)map));
        }
        return annotationAttributes;
    }

    private ConditionOutcome determineOutcome(AnnotationAttributes annotationAttributes, ApplicationArguments resolver) {
        Spec spec = new Spec(annotationAttributes);
        ArrayList<String> missingProperties = new ArrayList<String>();
        spec.collectProperties(resolver, missingProperties);
        if (!missingProperties.isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnCommand.class, (Object[])new Object[]{spec}).didNotFind("command", "commands").items(ConditionMessage.Style.QUOTE, missingProperties));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnCommand.class, (Object[])new Object[]{spec}).because("matched"));
    }

    private static class Spec {
        private final String[] names;
        private final boolean matchIfMissing;

        Spec(AnnotationAttributes annotationAttributes) {
            this.names = this.getNames((Map<String, Object>)annotationAttributes);
            this.matchIfMissing = annotationAttributes.getBoolean("matchIfMissing");
        }

        private String[] getNames(Map<String, Object> annotationAttributes) {
            String[] value = (String[])annotationAttributes.get("value");
            String[] name = (String[])annotationAttributes.get("name");
            Assert.state((value.length > 0 || name.length > 0 ? 1 : 0) != 0, (String)"The name or value attribute of @ConditionalOnCommand must be specified");
            Assert.state((value.length == 0 || name.length == 0 ? 1 : 0) != 0, (String)"The name and value attributes of @ConditionalOnCommand are exclusive");
            return value.length > 0 ? value : name;
        }

        private void collectProperties(ApplicationArguments resolver, List<String> missing) {
            String[] sourceArgs = resolver.getSourceArgs();
            String commandOrNull = sourceArgs.length > 0 ? sourceArgs[0] : null;
            for (String name : this.names) {
                if (name.equals(commandOrNull) || this.matchIfMissing) continue;
                missing.add(name);
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("(");
            if (this.names.length == 1) {
                result.append(this.names[0]);
            } else {
                result.append("[");
                result.append(StringUtils.arrayToCommaDelimitedString((Object[])this.names));
                result.append("]");
            }
            result.append(")");
            return result.toString();
        }
    }
}

