/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor.command;

import java.util.Optional;
import lombok.NonNull;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.tbk.ngtor.conditional.ConditionalOnCommand;
import org.tbk.tor.hs.HiddenServiceDefinition;

@Component
@ConditionalOnCommand(value={"demo"})
public class DemoCommand
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(DemoCommand.class);
    @NonNull
    private final Tor tor;
    @NonNull
    private final HiddenServiceDefinition hiddenServiceDefinition;

    public void run(ApplicationArguments args) {
        Optional<String> httpUrl = this.hiddenServiceDefinition.getVirtualHost().map(val -> "http://" + val + ":" + this.hiddenServiceDefinition.getVirtualPort());
        log.info("=================================================");
        log.info("url: {}", (Object)httpUrl.orElse("unavailable"));
        log.info("virtual host: {}", (Object)this.hiddenServiceDefinition.getVirtualHost().orElse("unavailable"));
        log.info("virtual port: {}", (Object)this.hiddenServiceDefinition.getVirtualPort());
        log.info("host: {}", (Object)this.hiddenServiceDefinition.getHost());
        log.info("port: {}", (Object)this.hiddenServiceDefinition.getPort());
        log.info("directory: {}", (Object)this.hiddenServiceDefinition.getDirectory().getAbsolutePath());
        httpUrl.ifPresent(url -> {
            log.info("-------------------------------------------------");
            try {
                log.info("Or browse to {} in Tor Browser, or", url);
                log.info("run: `torsocks -p {} curl {}/index.html -v`", (Object)this.tor.getProxy().getPort(), url);
            }
            catch (TorCtlException e) {
                log.warn("Could not get tor proxy port");
            }
        });
        log.info("=================================================");
    }

    public DemoCommand(@NonNull Tor tor, @NonNull HiddenServiceDefinition hiddenServiceDefinition) {
        if (tor == null) {
            throw new IllegalArgumentException("tor is marked non-null but is null");
        }
        if (hiddenServiceDefinition == null) {
            throw new IllegalArgumentException("hiddenServiceDefinition is marked non-null but is null");
        }
        this.tor = tor;
        this.hiddenServiceDefinition = hiddenServiceDefinition;
    }
}

