/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.boot.web.context.WebServerPortFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;

@SpringBootApplication
public class NgtorApplication
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(NgtorApplication.class);
    private static final Set<String> commands = Set.of("http", "serve", "check", "demo", "help", "version");
    private static final Set<String> torCommands = Set.of("http", "serve", "check", "demo");

    public static void main(String[] args) {
        DefaultApplicationArguments arguments = new DefaultApplicationArguments(args);
        boolean demoMode = args.length > 0 && "demo".equals(args[0]);
        boolean webapp = arguments.containsOption("webapp") || demoMode;
        List<String> argsList = NgtorApplication.buildArgsList(args);
        if (webapp) {
            NgtorApplication.startWebApplication(StringUtils.toStringArray(argsList));
        } else {
            NgtorApplication.startConsoleApplication(StringUtils.toStringArray(argsList));
        }
    }

    private static List<String> buildArgsList(String[] args) {
        String command;
        boolean unknownCommand;
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        if (argsList.isEmpty()) {
            argsList.add("help");
        }
        boolean bl = unknownCommand = !commands.contains(command = (String)argsList.get(0));
        if (unknownCommand) {
            throw new IllegalArgumentException("Unknown command: " + command);
        }
        boolean enableTor = torCommands.contains(command);
        argsList.add("--org.tbk.tor.enabled=" + enableTor);
        boolean publishHiddenService = "demo".equals(command);
        argsList.add("--org.tbk.tor.auto-publish-enabled=" + publishHiddenService);
        return argsList;
    }

    private static void startConsoleApplication(String[] args) {
        new SpringApplicationBuilder(new Class[0]).sources(new Class[]{NgtorApplication.class}).listeners(new ApplicationListener[]{NgtorApplication.applicationPidFileWriter()}).web(WebApplicationType.NONE).bannerMode(Banner.Mode.OFF).logStartupInfo(false).run(args);
    }

    public static void startWebApplication(String[] args) {
        new SpringApplicationBuilder(new Class[0]).sources(new Class[]{NgtorApplication.class}).listeners(new ApplicationListener[]{NgtorApplication.applicationPidFileWriter(), NgtorApplication.webServerPortFileWriter()}).web(WebApplicationType.SERVLET).bannerMode(Banner.Mode.OFF).logStartupInfo(true).run(args);
    }

    public static ApplicationListener<?> applicationPidFileWriter() {
        return new ApplicationPidFileWriter("application.pid");
    }

    public static ApplicationListener<?> webServerPortFileWriter() {
        return new WebServerPortFileWriter("application.port");
    }

    public void afterPropertiesSet() {
        log.info("Starting..");
    }
}

