/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor.command;

import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.tbk.ngtor.conditional.ConditionalOnCommand;
import org.tbk.ngtor.util.ConsoleColors;
import org.tbk.tor.hs.HiddenServiceDefinition;

@Component
@ConditionalOnCommand(value={"http"})
public class HttpCommand
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(HttpCommand.class);
    @NonNull
    private final HiddenServiceDefinition hiddenServiceDefinition;

    public void run(ApplicationArguments args) {
        log.debug("Hidden service served from directory '{}'", (Object)this.hiddenServiceDefinition.getDirectory());
        String message = String.format("Service '%s' to %s:%d activated on: %s", this.hiddenServiceDefinition.getName(), this.hiddenServiceDefinition.getHost(), this.hiddenServiceDefinition.getPort(), this.buildOnionUrl(this.hiddenServiceDefinition));
        System.out.println(ConsoleColors.green((String)"\u2714") + " " + message);
        log.info(message);
    }

    private String buildOnionUrl(HiddenServiceDefinition applicationHiddenServiceDefinition) {
        return applicationHiddenServiceDefinition.getVirtualHost().map(virtualHost -> {
            int port = applicationHiddenServiceDefinition.getVirtualPort();
            if (port == 80) {
                return "http://" + virtualHost;
            }
            if (port == 443) {
                return "https://" + virtualHost;
            }
            return "http://" + virtualHost + ":" + port;
        }).orElseThrow(() -> new IllegalStateException("Could not build onion url"));
    }

    public HttpCommand(@NonNull HiddenServiceDefinition hiddenServiceDefinition) {
        if (hiddenServiceDefinition == null) {
            throw new IllegalArgumentException("hiddenServiceDefinition is marked non-null but is null");
        }
        this.hiddenServiceDefinition = hiddenServiceDefinition;
    }
}

