/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor;

import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.tbk.ngtor.tor.TorHttpCheck;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
class NgtorApplicationWebConfig {
    private static final Logger log = LoggerFactory.getLogger(NgtorApplicationWebConfig.class);
    @Autowired
    @Qualifier(value="torHttpClient")
    private HttpClient torHttpClient;

    NgtorApplicationWebConfig() {
    }

    @Bean
    @Profile(value={"!test"})
    public ApplicationRunner torHttpCheckRunner() {
        return args -> {
            boolean torEnabled = new TorHttpCheck(this.torHttpClient).check();
            log.info("=================================================");
            if (torEnabled) {
                log.info("Tor is working correctly.");
            } else {
                log.warn("Tor is NOT working correctly.");
            }
            log.info("=================================================");
        };
    }
}

