/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.ngtor.tor;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public final class TorHttpCheck {
    private static final String TOR_CHECK_URL = "https://check.torproject.org/";
    @NonNull
    private final HttpClient torHttpClient;

    public boolean check() throws IOException {
        String successPhrase = "Congratulations. This browser is configured to use Tor.";
        String errorPhraseIgnoreCase = "not using Tor";
        HttpGet req = new HttpGet(TOR_CHECK_URL);
        HttpResponse rsp = this.torHttpClient.execute((HttpUriRequest)req);
        String body = EntityUtils.toString((HttpEntity)rsp.getEntity(), (Charset)StandardCharsets.UTF_8);
        boolean containsErrorPhrase = body.toLowerCase(Locale.US).contains(errorPhraseIgnoreCase.toLowerCase(Locale.US));
        boolean containsSuccessPhrase = body.contains(successPhrase);
        return containsSuccessPhrase && !containsErrorPhrase;
    }

    public TorHttpCheck(@NonNull HttpClient torHttpClient) {
        if (torHttpClient == null) {
            throw new IllegalArgumentException("torHttpClient is marked non-null but is null");
        }
        this.torHttpClient = torHttpClient;
    }
}

