<?php
session_start();
require 'db.php'; // Include your database connection

// Check if a username has been submitted from login.php and set it in the session
if (isset($_POST['username']) && !empty(trim($_POST['username']))) {
    $_SESSION['username'] = trim($_POST['username']);
    header('Location: index.php'); // Redirect to the main chat page to prevent form resubmission
    exit();
}

// Redirect to login.php if username not set in the session
if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

// Initialize auto-refresh state
if (!isset($_SESSION['auto_refresh'])) {
    $_SESSION['auto_refresh'] = true; // Auto-refresh is enabled by default
}

// Toggle auto-refresh state
if (isset($_POST['toggle_refresh'])) {
    $_SESSION['auto_refresh'] = !$_SESSION['auto_refresh'];
    header('Location: index.php'); // Redirect to prevent form resubmission
    exit();
}

// Set auto-refresh header if enabled
if ($_SESSION['auto_refresh']) {
    header("Refresh:10");
}

// Handle message submission and logging
if (isset($_POST['message']) && !empty($_POST['message'])) {
    $message = $_POST['message'];
    $username = $_SESSION['username'];

    // Insert into database
    $sql = "INSERT INTO messages (username, message) VALUES (?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$username, $message]);

    // Log message to messages.txt
    $logMessage = date('Y-m-d H:i:s') . " - {$username}: {$message}\n";
    file_put_contents('messages.txt', $logMessage, FILE_APPEND);

    header('Location: index.php'); // Redirect to prevent form resubmission
    exit();
}

// Retrieve messages from database
$sql = "SELECT * FROM messages ORDER BY created_at DESC";
$stmt = $pdo->query($sql);
$messages = $stmt->fetchAll();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HablARR</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .chat-box { height: 300px; overflow-y: scroll; border: 1px solid #ccc; padding: 10px; margin-bottom: 10px; }
        .chat-form { margin-top: 10px; }
    </style>
</head>
<body>
    <h1>Welcome to the HablARR chatroom!</h1>
    <p>It's pretty vulnerable, feel free to see what you can poke around with! (no JS, just PHP, hence the refresh every 10 seconds)</p>
    <p>Only rule is to just be a decent human being, and share any vulnerabilities you find if you want.</p>
    <div class="chat-box">
        <?php foreach ($messages as $message): ?>
            <div><?php echo htmlspecialchars($message['username']) . ": " . htmlspecialchars($message['message']); ?></div>
        <?php endforeach; ?>
    </div>
    <form class="chat-form" method="post">
        <input type="text" name="message" placeholder="Type your message here...">
        <button type="submit">Send</button>
    </form>
    <form method="post">
        <button type="submit" name="toggle_refresh"><?php echo $_SESSION['auto_refresh'] ? 'Pause Auto Refresh' : 'Unpause Auto Refresh'; ?></button><br><sup>(for longer messages)</sup>
    </form>
</body>
</html>
