<?php
session_start();

// Check if the form has been submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['username'])) {
    // Check if the username field is not empty
    if (!empty(trim($_POST['username']))) {
        // Set the username in the session
        $_SESSION['username'] = trim($_POST['username']);
        
        // Redirect to the chat page
        header('Location: index.php');
        exit();
    } else {
        // Handle the case where the username field is empty
        $error = "Username cannot be empty.";
    }
}

// Redirect if already logged in
if (isset($_SESSION['username'])) {
    header('Location: index.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
</head>
<body>
    <?php
    // Display error message if set
    if (isset($error)) {
        echo "<p style='color: red;'>$error</p>";
    }
    ?>
    <form method="post" action="">
        <label for="username">Username:</label>
        <input type="text" id="username" name="username" required>
        <button type="submit">Enter Chat</button>
    </form>
</body>
</html>
