


# Keycloak - Identity and Access Management for Modern Applications

<a href="https://www.packtpub.com/product/keycloak-identity-and-access-management-for-modern-applications/9781800562493?utm_source=github&utm_medium=repository&utm_campaign=9781800562493"><img src="https://static.packt-cdn.com/products/9781800562493/cover/smaller" alt="Keycloak - Identity and Access Management for Modern Applications" height="256px" align="right"></a>

This is the code repository for [Keycloak - Identity and Access Management for Modern Applications](https://www.packtpub.com/product/keycloak-identity-and-access-management-for-modern-applications/9781800562493?utm_source=github&utm_medium=repository&utm_campaign=9781800562493), published by Packt.

**Harness the power of Keycloak, OpenID Connect, and OAuth 2.0 protocols to secure applications**

## What is this book about?
Implementing authentication and authorization for applications can be a daunting experience, often leaving them exposed to security vulnerabilities. Keycloak is an open-source solution for identity management and access management for modern applications.

This book covers the following exciting features: 
* Understand how to install, configure, and manage Keycloak
* Secure your new and existing applications with Keycloak
* Gain a basic understanding of OAuth 2.0 and OpenID Connect
* Understand how to configure Keycloak to make it ready for production use
* Discover how to leverage additional features and how to customize Keycloak to fit your needs

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1800562497) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
if (test expression)
{
  Statement upon condition is true
}
```

**Following is what you need for this book:**
Developers, sysadmins, security engineers, or anyone who wants to leverage Keycloak and its capabilities for application security will find this book useful. Beginner-level knowledge of app development and authentication and authorization is expected.


With the following software and hardware list you can run all code files present in the book (Chapter 1-14).

### Software and Hardware List

| Chapter  | Software required                   | OS required                        |
| -------- | ------------------------------------| -----------------------------------|
| 1-14        | Keycloak 12                      | Windows, macOS, and Linux (Any) |
| 1-14        | OpenJDK 8+                       | Windows, macOS, and Linux (Any) |
| 1-14       | Node.js 14+                       | Windows, Mac OS, and Linux (Any) |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](http://www.packtpub.com/sites/default/files/downloads/9781800562493_ColorImages.pdf).

## Code in Action

Click on the following link to see the Code in Action:

[YouTube](https://www.youtube.com/playlist?list=PLeLcvrwLe187DykEKXg-9Urd1Z6MQT61d)

## Errata

* Page 6 (Paragraph 5, line 1): `$ docker run -e KEYCLOAK_USER=admin -e KEYCLOAK_PASSWORD=admin -p 8080 quay.io/keycloak/keycloak` _should be_`$ docker run -e KEYCLOAK_USER=admin -e KEYCLOAK_PASSWORD=admin -p 8080:8080 quay.io/keycloak/keycloak`

### Related products 
* Okta Administration: Up and Running [[Packt]](https://www.packtpub.com/product/okta-administration-up-and-running/9781800566644?utm_source=github&utm_medium=repository&utm_campaign=9781800562493) [[Amazon]](https://www.amazon.com/dp/1800566646)

* Mastering Identity and Access Management with Microsoft Azure - Second Edition [[Packt]](https://www.packtpub.com/product/mastering-identity-and-access-management-with-microsoft-azure-second-edition/9781789132304?utm_source=github&utm_medium=repository&utm_campaign=9781789132304) [[Amazon]](https://www.amazon.com/dp/1789132304)

## Get to Know the Authors
**Stian Thorgersen** started his career at Arjuna Technologies building a cloud federation platform, years before most companies were even ready for a single-vendor public cloud. He later joined Red Hat, looking for ways to make developers' lives easier, which is where the idea of Keycloak started. In 2013, Stian co-founded the Keycloak project with another developer at Red Hat. Today, Stian is the Keycloak project lead and is also the top contributor to the project. He is still employed by Red Hat as a senior principal software engineer focusing on identity and access management, both for Red Hat and for Red Hat's customers. In his spare time, there is nothing Stian likes more than throwing his bike down the mountains of Norway.

**Pedro Igor Silva** is a proud dad of amazing girls. He started his career back in 2000 at an ISP, where he had his first experiences with open source projects such as FreeBSD and Linux, as well as a Java and J2EE software engineer. Since then, he has worked in different IT companies as a system engineer, system architect, and consultant. Today, Pedro Igor is a principal software engineer at Red Hat and one of the core developers of Keycloak. His main area of interest and study is now IT security, specifically in the application security and identity and access management spaces. In his non-working hours, he takes care of his planted aquariums.
### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781800562493">https://packt.link/free-ebook/9781800562493 </a> </p>