


# Malware Analysis Techniques

<a href="https://www.packtpub.com/product/malware-analysis-techniques/9781839212277?utm_source=github&utm_medium=repository&utm_campaign=9781839212277"><img src="https://static.packt-cdn.com/products/9781839212277/cover/smaller" alt="Malware Analysis Techniques" height="256px" align="right"></a>

This is the code repository for [Malware Analysis Techniques](https://www.packtpub.com/product/malware-analysis-techniques/9781839212277?utm_source=github&utm_medium=repository&utm_campaign=9781839212277), published by Packt.

**Tricks for the triage of adversarial software**

## What is this book about?
Malicious software poses a threat to every enterprise globally. Its growth is costing businesses millions of dollars due to currency theft as a result of ransomware and lost productivity. With this book, you'll learn how to quickly triage, identify, attribute, and remediate threats using proven analysis techniques.

This book covers the following exciting features: 
* Discover how to maintain a safe analysis environment for malware samples
* Get to grips with static and dynamic analysis techniques for collecting IOCs
* Reverse-engineer and debug malware to understand its purpose
* Develop a well-polished workflow for malware analysis
* Understand when and where to implement automation to react quickly to threats

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1839212276) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
Here, you will find the sample packs that correspond with the chapter walkthroughs and challenges in the book. Please note that there is live malware in these archives in  several instances. As such, the archives are password protected with the password **"infected"**.

All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
if (test expression)
{
  Statement upon condition is true
}
```

**Following is what you need for this book:**
This book is for incident response professionals, malware analysts, and researchers who want to sharpen their skillset or are looking for a reference for common static and dynamic analysis techniques. Beginners will also find this book useful to get started with learning about malware analysis. Basic knowledge of command-line interfaces, familiarity with Windows and Unix-like filesystems and registries, and experience in scripting languages such as PowerShell, Python, or Ruby will assist with understanding the concepts covered.

With the following software and hardware list you can run all code files present in the book (Chapter 1-11).

### Software and Hardware List

| Chapter  | Software required                   | OS required                        |
| -------- | ------------------------------------| -----------------------------------|
| 1-11     | VMware Fusion, VirtualBox, or VMware Workstation | Windows or macOS |
| 1-11     | FlareVM                             | Windows or macOS |


We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](http://www.packtpub.com/sites/default/files/downloads/9781839212277_ColorImages.pdf).

### Related products 
* Mastering Malware Analysis [[Packt]](https://www.packtpub.com/product/mastering-malware-analysis/9781789610789?utm_source=github&utm_medium=repository&utm_campaign=9781789610789) [[Amazon]](https://www.amazon.com/dp/1789610788)

* Learn Computer Forensics [[Packt]](https://www.packtpub.com/product/learn-computer-forensics/9781838648176?utm_source=github&utm_medium=repository&utm_campaign=9781838648176) [[Amazon]](https://www.amazon.com/dp/1838648178)

## Get to Know the Author
**Dylan Barker** is a technology professional with ten years’ experience in the information security space, in industries ranging from K12 and telecom to financial services. He has held many distinct roles from security infrastructure engineering to vulnerability management. In the past, he has spoken at BSides events, and has written articles for CrowdStrike - where he is currently employed as a Senior Analyst.







### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781839212277">https://packt.link/free-ebook/9781839212277 </a> </p>