# Chapter 4 - Blending In
This chapter is about the tradeoff between in-memory operations and blending into normal activity

## Topics

This chapter covers several topics such as:

-   LOLbins
-   DLL search order hijacking
-   Executable file infection
-   Covert command and control (C2) channels
-   ICMP C2
-   DNS C2
-   Domain fronting
-   Combining offensive techniques
-   Detecting ICMP C2
-   Detecting DNS C2
-   Windows centralized DNS
-   DNS insight with Sysmon
-   Network monitoring
-   DNS analysis
-   Detecting DLL search order hijacking
-   Detecting backdoored executables
-   Honey tokens
-   Honeypots

## Code
The following are some of the code samples included in this chapter:

- [windows_LOLbins.md](https://github.com/ahhh/Cybersecurity-Tradecraft/blob/main/Chapter4/windows_LOLbins.md)
	- Some examples of Windows Living Off the Land binaries
- [windows_SysmonLogs.md](https://github.com/ahhh/Cybersecurity-Tradecraft/blob/main/Chapter4/windows_SysmonLogs.md)
    - Some automation around retrieving and parsing Sysmon and Windows Event Logs 
