


# Industrial Cybersecurity - Second Edition

<a href="https://www.packtpub.com/in/security/industrial-cybersecurity-second-edition?utm_source=github&utm_medium=repository&utm_campaign=9781800202092"><img src="https://static.packt-cdn.com/products/9781800202092/cover/smaller" alt="Industrial Cybersecurity - Second Edition" height="256px" align="right"></a>

This is the code repository for [Industrial Cybersecurity - Second Edition](https://www.packtpub.com/in/security/industrial-cybersecurity-second-edition?utm_source=github&utm_medium=repository&utm_campaign=9781800202092), published by Packt.

**Efficiently monitor the cybersecurity posture of your ICS environment**

## What is this book about?
With IT industries expanding on the cloud, cyberattacks have increased significantly, making it crucial for you to be able to recognize your control system's vulnerabilities and implement advanced techniques to defend critical infrastructure systems against rapidly evolving cyber threats. This second edition of Industrial Cybersecurity covers the updated Industrial Demilitarized Zone (IDMZ) architecture and shows you how to implement a solid security program for the Industrial Control System (ICS) environment. 

This book covers the following exciting features:
* Monitor the ICS security posture actively as well as passively
* Respond to incidents in a controlled and standard way
* Understand what incident response activities are required in your ICS environment
* Perform threat-hunting exercises using the Elasticsearch, Logstash, and Kibana (ELK) stack
* Assess the overall effectiveness of your ICS cybersecurity program
Discover tools, techniques, methodologies, and activities to perform risk assessments for your ICS environment

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1800202091) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
<localfile>
  <location>Microsoft-Windows-Sysmon/Operational</location>
  <log_format>eventchannel</log_format>
</localfile>
```

**Following is what you need for this book:**
If you are an ICS security professional or anyone curious about ICS cybersecurity for extending, improving, monitoring, and validating your ICS cybersecurity posture, then this book is for you. IT/OT professionals interested in entering the ICS cybersecurity monitoring domain or searching for additional learning material for different industry-leading cybersecurity certifications will also find this book useful.

With the following software and hardware list you can run all code files present in the book (Chapter 1-19).
### Software and Hardware List
| Chapter | Software required | Version |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-19 | Kali Linux | 2020+ |
| 1-19 | Pfsense Firewall | 2.5+ |
| 1-19 | Security Onion | 2.3+ |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](http://www.packtpub.com/sites/default/files/downloads/9781800202092_ColorImages.pdf).

### Related products
* Practical Threat Intelligence and Data-Driven Threat Hunting [[Packt]](https://www.packtpub.com/product/practical-threat-intelligence-and-data-driven-threat-hunting/9781838556372?utm_source=github&utm_medium=repository&utm_campaign=9781838556372) [[Amazon]](https://www.amazon.com/dp/1838556370)

* CompTIA Security+ Practice Tests SY0-501 [[Packt]](https://www.packtpub.com/product/comptia-security-practice-tests-sy0-501/9781838828882?utm_source=github&utm_medium=repository&utm_campaign=9781838828882) [[Amazon]](https://www.amazon.com/dp/1800564244)

## Get to Know the Author
**Pascal Ackerman**
is a seasoned industrial security professional with a degree in electrical engineering and over 20 years of experience in industrial network design and support, information and network security, risk assessments, pentesting, threat hunting, and forensics. After almost two decades of hands-on, in-the-field, and consulting experience, he joined ThreatGEN in 2019 and is currently employed as managing director of threat services and research. His passion lies in analyzing new and existing threats to ICS environments and he fights cyber adversaries both from his home base and while traveling the world with his family as a digital nomad.
Pascal wrote the previous edition of this book and has been a reviewer and technical consultant of many security books.
### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781800202092">https://packt.link/free-ebook/9781800202092 </a> </p>