


# Mastering Palo Alto Networks

<a href="https://www.packtpub.com/cloud-networking/mastering-palo-alto-networks?utm_source=github&utm_medium=repository&utm_campaign=9781789956375"><img src="https://www.packtpub.com/media/catalog/product/cache/4cdce5a811acc0d2926d7f857dceb83b/9/7/9781789956375-original_47.png" alt="Mastering Palo Alto Networks" height="256px" align="right"></a>

This is the code repository for [Mastering Palo Alto Networks](https://www.packtpub.com/cloud-networking/mastering-palo-alto-networks?utm_source=github&utm_medium=repository&utm_campaign=9781789956375), published by Packt.

**Deploy and manage industry-leading PAN-OS 10.x solutions to secure your users and infrastructure**

## What is this book about?
To safeguard against security threats, it is crucial to ensure that your organization is effectively secured across networks, mobile devices, and the cloud. Palo Alto Networks’ integrated platform makes it easy to manage network and cloud security along with endpoint protection and a wide range of security services. With this book, you'll understand Palo Alto Networks and learn how to implement essential techniques, right from deploying firewalls through to advanced troubleshooting.ription

This book covers the following exciting features: 
* Perform administrative tasks using the web interface and command-line interface (CLI)
* Explore the core technologies that will help you boost your network security
* Discover best practices and considerations for configuring security policies
* Run and interpret troubleshooting and debugging commands
* Manage firewalls through Panorama to reduce administrative workloads

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1789956374) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
if (test expression)
{
  Statement upon condition is true
}
```

**Following is what you need for this book:**
This book is for network engineers, network security analysts, and security professionals who want to understand and deploy Palo Alto Networks in their infrastructure. Anyone looking for in-depth knowledge of Palo Alto Network technologies, including those who currently use Palo Alto Network products, will find this book useful. Intermediate-level network administration knowledge is necessary to get started with this cybersecurity book.

With the following software and hardware list you can run all code files present in the book (Chapter 1-13).

### Software and Hardware List

| Chapter  | Software required                   | OS required                                              |
| -------- | ------------------------------------| ---------------------------------------------------------|
| 1-13     | PAN-OS, all chassis and VM versions | Any OS capable of supporting a web browser and SSH client|



We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](http://www.packtpub.com/sites/default/files/downloads/9781789956375_ColorImages.pdf).

## Code in Action

Click on the following link to see the Code in Action:

[YouTube](https://www.youtube.com/playlist?list=PLeLcvrwLe185oVaR7utR4mKlqow4VImk_)

### Related products 
* Cybersecurity Attacks – Red Team Strategies [[Packt]](https://www.packtpub.com/security/cybersecurity-attacks-red-team-strategies?utm_source=github&utm_medium=repository&utm_campaign=9781838828868) [[Amazon]](https://www.amazon.com/dp/1838828869)

* Mastering Windows Security and Hardening [[Packt]](https://www.packtpub.com/security/mastering-windows-security-and-hardening?utm_source=github&utm_medium=repository&utm_campaign=9781839216411) [[Amazon]](https://www.amazon.com/dp/1839216417)

## Get to Know the Author

**Tom Piens**, PCNSE, CISSP, and founder of PANgurus, has nearly 10 years of experience working with Palo Alto Networks customers. Tom has been at the forefront of engaging with customers, responding to questions, and analyzing unique needs to apply the best possible solutions or workarounds. He has authored a great many articles on the Palo Alto Networks knowledge base and discussion forum solutions, including the popular Getting Started series. Also known as “reaper” on the PANgurus and LIVEcommunity forums, and @PANWreaper on Twitter, Tom has been recognized by Palo Alto Networks user groups and community members, and by countless thankful customers.


### Suggestions and Feedback
[Click here](https://docs.google.com/forms/d/e/1FAIpQLSdy7dATC6QmEL81FIUuymZ0Wy9vH1jHkvpY57OiMeKGqib_Ow/viewform) if you have any feedback or suggestions.
### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781789956375">https://packt.link/free-ebook/9781789956375 </a> </p>