transport select jtag
#reset_config trst_and_srst
reset_config srst_only
adapter_nsrst_delay 100

ftdi_tdo_sample_edge falling

adapter_khz 30000


set  _CHIPNAME S3C45
set  _ENDIAN little

if { [info exists CPUTAPID ] } {
    set _CPUTAPID $CPUTAPID
} else {
    set _CPUTAPID 0x1f0f0f0f
}

jtag newtap $_CHIPNAME cpu -irlen 4 -ircapture 0x1 -irmask 0xf -expected-id $_CPUTAPID
set _TARGETNAME [format "%s.cpu" $_CHIPNAME]

target create $_TARGETNAME arm7tdmi -endian $_ENDIAN -chain-position $_TARGETNAME

$_TARGETNAME configure -work-area-phys 0x30800000 -work-area-size 0x20000 -work-area-backup 0

#flash bank [format "%s.flash" $_CHIPNAME] cfi 0 0 0 0 $_TARGETNAME
#flash banks
#flash probe 0

#arm7_9 fast_memory_access enable
#arm7_9 dcc_downloads enable


telnet_port 4444
gdb_port 3333
tcl_port 6666
init
#reset init
verify_ircapture disable
halt
wait_halt
poll

