


# Threat Hunting with Elastic Stack

<a href="https://www.packtpub.com/product/threat-hunting-with-elastic-stack/9781801073783?utm_source=github&utm_medium=repository&utm_campaign=9781801073783"><img src="https://static.packt-cdn.com/products/9781801073783/cover/smaller" alt="Threat Hunting with Elastic Stack" height="256px" align="right"></a>

This is the code repository for [Threat Hunting with Elastic Stack](https://www.packtpub.com/product/threat-hunting-with-elastic-stack/9781801073783?utm_source=github&utm_medium=repository&utm_campaign=9781801073783), published by Packt.

**Solve complex security challenges with integrated prevention, detection, and response**

## What is this book about?
Elastic Security is an open solution that equips professionals with the tools to prevent, detect, and respond to threats. Threat Hunting with Elastic Stack will show you how to make the best use of Elastic Security to provide optimal protection against cyber threats. With this book, security practitioners working with Kibana will be able to put their knowledge to work and detect malicious adversary activity within their contested network. 

This book covers the following exciting features:
Explore cyber threat intelligence analytical models and hunting methodologies
Build and configure Elastic Stack for cyber threat hunting
Leverage the Elastic endpoint and Beats for data collection
Perform security data analysis using the Kibana Discover, Visualize, and Dashboard apps
Execute hunting and response operations using the Kibana Security app
Use Elastic Common Schema to ensure data uniformity across organizations

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1801073783) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
{  "acknowledged" : true,  "shards_acknowledged" : true,  "index" : "my-first-index"}
```

**Following is what you need for this book:**
Security analysts, cybersecurity enthusiasts, information systems security staff, or anyone who works with the Elastic Stack for security monitoring, incident response, intelligence analysis, or threat hunting will find this book useful. Basic working knowledge of IT security operations and network and endpoint systems is necessary to get started.

With the following software and hardware list you can run all code files present in the book (Chapter 1-12).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-12 | Oracle VirtualBox | Windows, Mac OS X, and Linux (Any) |
| 1-12 | The Elastic Stack (Elasticsearch, Kibana, Beats, and the Elastic Agent) | Windows, Mac OS X, and Linux (Any) |


We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](http://www.packtpub.com/sites/default/files/downloads/9781801073783_ColorImages.pdf).

### Code in Action
Click on following link to see the Code in Action:

[Youtube link](https://bit.ly/3z4CAOV)

### Related products
* Modern Cryptography for Cybersecurity Professionals [[Packt]](https://www.packtpub.com/product/modern-cryptography-for-cybersecurity-professionals/9781838644352?utm_source=github&utm_medium=repository&utm_campaign=9781838644352) [[Amazon]](https://www.amazon.com/dp/1838644350)

* Python Ethical Hacking from Scratch [[Packt]](https://www.packtpub.com/product/python-ethical-hacking-from-scratch/9781838829506?utm_source=github&utm_medium=repository&utm_campaign=9781838829506) [[Amazon]](https://www.amazon.com/dp/1838829504)

## Get to Know the Author
**Andrew Pease**
began his journey into information security in 2002. He has performed security monitoring, incident response, threat hunting, and intelligence analysis for various organizations from the United States Department of Defense, a biotechnology company, and co-founded a security services company called Perched, which was acquired by Elastic in 2019. Andrew is currently employed with Elastic as a Principal Security Research Engineer where he performs intelligence and analytics research to identify adversary activity on contested networks. He has been using Elastic for network and endpoint-based threat hunting since 2013, He has developed training on security workloads using the Elastic Stack since 2017, and currently works with a team of brilliant engineers that develop detection logic for the Elastic Security App.


### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781801073783">https://packt.link/free-ebook/9781801073783 </a> </p>