package code;

import java.nio.*;
import javax.swing.*;
import static com.jogamp.opengl.GL4.*;
import com.jogamp.opengl.*;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.*;
import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GLContext;

public class Code extends JFrame implements GLEventListener
{	private GLCanvas myCanvas;
	private int computeShaderProgram;
	private int buffer[] = new int[3];
	private float[] v1 = { 10, 12, 16, 18, 50, 17 };
	private float[] v2 = { 30, 14, 80, 20, 51, 12 };
	private float res[] = new float[6];

	public Code()
	{	setSize(600, 400);
		myCanvas = new GLCanvas();
		myCanvas.addGLEventListener(this);
		this.add(myCanvas);
		this.setVisible(true);
	}

	public void display(GLAutoDrawable drawable)
	{	GL4 gl = (GL4) GLContext.getCurrentGL();
		computeSum();
		System.out.println(v1[0] + " " + v1[1] + " " + v1[2] + " " + v1[3] + " " + v1[4] + " " + v1[5]);
		System.out.println(v2[0] + " " + v2[1] + " " + v2[2] + " " + v2[3] + " " + v2[4] + " " + v2[5]);
		System.out.println(res[0] + " " + res[1] + " " + res[2] + " " + res[3] + " " + res[4] + " " + res[5]);
	}

	public void init(GLAutoDrawable drawable)
	{	GL4 gl = (GL4) GLContext.getCurrentGL();
		computeShaderProgram = Utils.createShaderProgram("code/computeShader.glsl");
		gl.glGenBuffers(3, buffer, 0);
		gl.glBindBuffer(GL_SHADER_STORAGE_BUFFER, buffer[0]);
		FloatBuffer v1Buf = Buffers.newDirectFloatBuffer(v1);
		gl.glBufferData(GL_SHADER_STORAGE_BUFFER, v1Buf.limit()*4, v1Buf, GL_STATIC_DRAW);
		gl.glBindBuffer(GL_SHADER_STORAGE_BUFFER, buffer[1]);
		FloatBuffer v2Buf = Buffers.newDirectFloatBuffer(v2);
		gl.glBufferData(GL_SHADER_STORAGE_BUFFER, v2Buf.limit()*4, v2Buf, GL_STATIC_DRAW);
		gl.glBindBuffer(GL_SHADER_STORAGE_BUFFER, buffer[2]);
		FloatBuffer resBuf = Buffers.newDirectFloatBuffer(res.length);
		gl.glBufferData(GL_SHADER_STORAGE_BUFFER, resBuf.limit()*4, null, GL_STATIC_READ);
	}

	private void computeSum() {
		GL4 gl = (GL4) GLContext.getCurrentGL();
		gl.glUseProgram(computeShaderProgram);

		gl.glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 0, buffer[0]);
		gl.glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 1, buffer[1]);
		gl.glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 2, buffer[2]);

		gl.glDispatchCompute(6, 1, 1);
		gl.glFinish();

		gl.glBindBuffer(GL_SHADER_STORAGE_BUFFER, buffer[2]);
		FloatBuffer resBuf = Buffers.newDirectFloatBuffer(res.length);
		gl.glGetBufferSubData(GL_SHADER_STORAGE_BUFFER, 0, resBuf.limit()*4, resBuf);
		
		res[0] = resBuf.get();
		res[1] = resBuf.get();
		res[2] = resBuf.get();
		res[3] = resBuf.get();
		res[4] = resBuf.get();
		res[5] = resBuf.get();
	}

	public static void main(String[] args) { new Code(); }
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {}
	public void dispose(GLAutoDrawable drawable) {}
}