package code;

import java.nio.*;
import javax.swing.*;
import static com.jogamp.opengl.GL4.*;
import com.jogamp.opengl.*;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.*;
import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GLContext;

public class Code extends JFrame implements GLEventListener
{	private GLCanvas myCanvas;
	private int vao[] = new int[1];
	private int vbo[] = new int[2];
	private int screenQuadShader, raytraceComputeShader;

	private int raytraceRenderWidth = 512;
	private int raytraceRenderHeight = 512;
	private int workGroupsX = raytraceRenderWidth;
	private int workGroupsY = raytraceRenderHeight;
	private int workGroupsZ = 1;

	private int[] screenTextureID = new int[1];
	private byte[] screenTexture = new byte[raytraceRenderWidth * raytraceRenderHeight * 16];
	private int earthTexture, brickTexture;
	private int xpTex, xnTex, ypTex, ynTex, zpTex, znTex;

	public Code()
	{	setSize(raytraceRenderWidth, raytraceRenderHeight);
		setTitle("Chapter 16 - program 7");
		myCanvas = new GLCanvas();
		myCanvas.addGLEventListener(this);
		this.add(myCanvas);
		this.setVisible(true);
	}

	public void init(GLAutoDrawable drawable)
	{	GL4 gl = (GL4) GLContext.getCurrentGL();
		screenQuadShader = Utils.createShaderProgram("code/vertShader.glsl", "code/fragShader.glsl");
		raytraceComputeShader = Utils.createShaderProgram("code/raytraceComputeShader.glsl");

		brickTexture = Utils.loadTexture("code/brick1.jpg");
		earthTexture = Utils.loadTexture("code/earthmap1k.jpg");
		xpTex = Utils.loadTexture("code/cubeMap/xp.jpg");
		xnTex = Utils.loadTexture("code/cubeMap/xn.jpg");
		ypTex = Utils.loadTexture("code/cubeMap/yp.jpg");
		ynTex = Utils.loadTexture("code/cubeMap/yn.jpg");
		zpTex = Utils.loadTexture("code/cubeMap/zp.jpg");
		znTex = Utils.loadTexture("code/cubeMap/zn.jpg");

		for (int i=0; i<raytraceRenderHeight; i++)
		{	for (int j=0; j<raytraceRenderHeight; j++)
			{	screenTexture[i*raytraceRenderWidth * 4 + j * 4 + 0] = (byte) 250;
				screenTexture[i*raytraceRenderWidth * 4 + j * 4 + 1] = (byte) 128;
				screenTexture[i*raytraceRenderWidth * 4 + j * 4 + 2] = (byte) 255;
				screenTexture[i*raytraceRenderWidth * 4 + j * 4 + 3] = (byte) 255;
		}	}

		ByteBuffer screenTextureBuffer = Buffers.newDirectByteBuffer(screenTexture);
		gl.glGenTextures(1, screenTextureID, 0);
		gl.glBindTexture(GL_TEXTURE_2D, screenTextureID[0]);
		gl.glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		gl.glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		gl.glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, raytraceRenderWidth, raytraceRenderHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, screenTextureBuffer);

		float[] fullscreenQuadVerts =
		{	-1.0f, 1.0f, 0.0f,  -1.0f,-1.0f, 0.0f,  1.0f, -1.0f, 0.0f,
			1.0f, -1.0f, 0.0f,  1.0f,  1.0f, 0.0f,  -1.0f,  1.0f, 0.0f
		};
		float[] fullscreenQuadUVs =
		{	0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f,
			1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f
		};

		gl.glGenVertexArrays(vao.length, vao, 0);
		gl.glBindVertexArray(vao[0]);
		gl.glGenBuffers(vbo.length, vbo, 0);
		
		gl.glBindBuffer(GL_ARRAY_BUFFER, vbo[0]);
		FloatBuffer quadVertsBuf = Buffers.newDirectFloatBuffer(fullscreenQuadVerts);
		gl.glBufferData(GL_ARRAY_BUFFER, quadVertsBuf.limit()*4, quadVertsBuf, GL_STATIC_DRAW);

		gl.glBindBuffer(GL_ARRAY_BUFFER, vbo[1]);
		FloatBuffer quadUVsBuf = Buffers.newDirectFloatBuffer(fullscreenQuadUVs);
		gl.glBufferData(GL_ARRAY_BUFFER, quadUVsBuf.limit()*4, quadUVsBuf, GL_STATIC_DRAW);
	}

	public void display(GLAutoDrawable drawable)
	{	GL4 gl = (GL4) GLContext.getCurrentGL();
		gl.glUseProgram(raytraceComputeShader);

		// Bind the screen_texture_id texture to an image unit as the compute shader's output
		gl.glBindImageTexture(0, screenTextureID[0], 0, false, 0, GL_WRITE_ONLY, GL_RGBA8);

		gl.glActiveTexture(GL_TEXTURE1);
		gl.glBindTexture(GL_TEXTURE_2D, earthTexture);
		gl.glActiveTexture(GL_TEXTURE2);
		gl.glBindTexture(GL_TEXTURE_2D, brickTexture);
		gl.glActiveTexture(GL_TEXTURE3);
		gl.glBindTexture(GL_TEXTURE_2D, xpTex);
		gl.glActiveTexture(GL_TEXTURE4);
		gl.glBindTexture(GL_TEXTURE_2D, xnTex);
		gl.glActiveTexture(GL_TEXTURE5);
		gl.glBindTexture(GL_TEXTURE_2D, ypTex);
		gl.glActiveTexture(GL_TEXTURE6);
		gl.glBindTexture(GL_TEXTURE_2D, ynTex);
		gl.glActiveTexture(GL_TEXTURE7);
		gl.glBindTexture(GL_TEXTURE_2D, zpTex);
		gl.glActiveTexture(GL_TEXTURE8);
		gl.glBindTexture(GL_TEXTURE_2D, znTex);

		gl.glActiveTexture(GL_TEXTURE0);

		gl.glDispatchCompute(workGroupsX, workGroupsY, workGroupsZ);
		gl.glFinish();  // block until all previous shader computation is complete

		//=======================================================
		// Call the shader program that draws the resulting texture to the screen
		//=======================================================
		gl.glUseProgram(screenQuadShader);
		gl.glClear(GL_COLOR_BUFFER_BIT);
		gl.glClear(GL_DEPTH_BUFFER_BIT);

		gl.glBindBuffer(GL_ARRAY_BUFFER, vbo[0]);
		gl.glVertexAttribPointer(0, 3, GL_FLOAT, false, 0, 0);
		gl.glEnableVertexAttribArray(0);
		gl.glBindBuffer(GL_ARRAY_BUFFER, vbo[1]);
		gl.glVertexAttribPointer(1, 2, GL_FLOAT, false, 0, 0);
		gl.glEnableVertexAttribArray(1);

		gl.glActiveTexture(GL_TEXTURE0);
		gl.glBindTexture(GL_TEXTURE_2D, screenTextureID[0]);

		gl.glEnable(GL_DEPTH_TEST);
		gl.glDepthFunc(GL_LEQUAL);

		gl.glDrawArrays(GL_TRIANGLES, 0, 6);
	}

	public static void main(String[] args) { new Code(); }
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {}
	public void dispose(GLAutoDrawable drawable) {}
}