import numpy as np
import pandas as pd
from scipy import stats
from sklearn import datasets 

df = datasets.load_iris()
columns = df.feature_names
iris_df = pd.DataFrame(df.data)
iris_df.columns = columns

print("=> iris_df.shape:",iris_df.shape)
print(iris_df.head())
print()

z = np.abs(stats.zscore(iris_df))
print("z scores for iris:")
print("z.shape:",z.shape)

upper = 2.5 
lower = 0.01
print("=> upper outliers:")
print(z[np.where(z > upper)])
print()
outliers = iris_df[z < lower]
print("=> lower outliers:")
print(outliers)
print()

#(array([15, 33, 73, 82, 90, 92, 95]), array([1, 1, 3, 3, 3, 3, 3]))
print("=> lower and upper outliers:")
print(np.where((z < lower) | (z > upper)))
print()

