import pandas as pd

schedule = ["Monday: Prepare lunch at 12:30pm for VIPs", 
            "Tuesday: Yoga class from 10:00am to 11:00am",
            "Wednesday: PTA meeting at library at 3pm",
            "Thursday: Happy hour at 5:45 at Julie's house.",
            "Friday: Prepare pizza dough for lunch at 1:15pm."]

# create a Pandas dataframe:
df = pd.DataFrame(schedule, columns = ['dow_of_week'])

# convert to lowercase:
df = df.applymap(lambda s:s.lower() if type(s) == str else s)
print("=> df:")
print(df)
print()

# character count for each string in df['dow_of_week']:
print("=> string lengths:")
print(df['dow_of_week'].str.len())
print()

# the number of tokens for each string in df['dow_of_week']
print("=> number of tokens in each string in df['dow_of_week']:")
print(df['dow_of_week'].str.split().str.len())
print()

# the number of occurrences of digits:
print("=> number of digits:")
print(df['dow_of_week'].str.count(r'\d')) 
print()

# display all occurrences of digits:
print("=> show all digits:")
print(df['dow_of_week'].str.findall(r'\d'))
print()

# display hour and minute values:
print("=> display (hour, minute) pairs:") 
print(df['dow_of_week'].str.findall(r'(\d?\d):(\d\d)'))
print()

# create new columns from hour:minute value:
print("=> hour and minute columns:")
print(df['dow_of_week'].str.extract(r'(\d?\d):(\d\d)'))
print()

