import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import seaborn as sns

df = pd.read_csv("employees2.csv")

print("=> contents of CSV file:")
print(df)
print()

print("=> sum of null values:")
print(df.isnull().any().sum())
print()

print("=> fields (and count) with null values:")
print(df.isnull().sum().sort_values(ascending=False))
print()

print("=> number of duplicate rows:")
print(df.duplicated().sum())
print()

print("=> row number(s):")
print(np.where(df.duplicated() == True)[0])

