#install.packages("rJava",repos = "http://cran.us.r-project.org")
#install.packages("NLP",repos = "http://cran.us.r-project.org")
#install.packages("openNLP",repos = "http://cran.us.r-project.org")

#library(rJava)
library(NLP)
library(openNLP)
#library(magrittr)

sent1 <- paste(c("I love Chicago deep dish pizza!", "Also Pizzeria Uno!"))
str1  <- as.String(sent1)

cat("\n")
print(paste0("contents of str1:"))
str1

cat("str1 tokens:","\n")
sent_token_annotator <- Maxent_Sent_Token_Annotator()
word_token_annotator <- Maxent_Word_Token_Annotator()
anntr2 <- annotate(str1, list(sent_token_annotator, word_token_annotator))
anntr2

cat("str1 annotations:","\n")
pos_tag_annotator <- Maxent_POS_Tag_Annotator()
anntr3 <- annotate(str1, pos_tag_annotator, anntr2)
anntr3

cat("subset of tokens:","\n")
anntr3_words <- subset(anntr3, type == "word")
anntr3_words 

cat("POS of tokens:","\n")
tags <- sapply(anntr3_words$features, '[[', "POS")
tags

cat("table:","\n")
table(tags)

# list of tokens/POS pairs:
sprintf("%s/%s", str1[anntr3_words], tags)

