
# => install spacyr with this command:
#devtools::install_github("kbenoit/spacyr", build_vignettes = FALSE)

# R wrapper for spaCy Python package to extract parts of speech:
library(spacyr) 

doc1 <- c("I love Chicago deep dish pizza.")
paste0("Extract POS and tags:",collapsed=" ")
spacy_parse(doc1, tag = TRUE, entity = FALSE, lemma = FALSE)

# extract entities from the output of spacy_parse():
parsedtxt <- spacy_parse(doc1, lemma = FALSE, entity = TRUE, nounphrase = TRUE)
paste0("Extract NER and tags:",collapsed=" ")
entity_extract(parsedtxt)

paste0("Extract noun phrases:",collapsed=" ")
nounphrase_extract(parsedtxt)

paste0("Dependency parsing:",collapsed=" ")
spacy_parse(doc1, dependency = TRUE, lemma = FALSE, pos = FALSE)

# install the Italian language model:
# spacy_download_langmodel('it') 
# from the command line via Python:
# python3.7 -m spacy download it

#spacy.load('it_core_news_sm')

spacy_finalize()
spacy_initialize(model = "it_core_news_sm")
txt_italian <- c(R = "R e una lingua gratis per programmare roba scientifica.")
results_italian <- spacy_parse(txt_italian, dependency = FALSE, lemma = FALSE, tag = TRUE)
paste0("Parse Italian:",collapsed=" ")
results_italian

