import transformers
import numpy as np

# instantiate a BERT tokenizer and model:
print("creating tokenizer...")
tokenizer = transformers.BertTokenizer.from_pretrained('bert-base-uncased', do_lower_case=True)
print("creating model...")
nlp = transformers.TFBertModel.from_pretrained('bert-base-uncased')

text="When were you last outside? I have been inside for 2 weeks."

encoding = tokenizer.encode_plus(
   text,
   max_length=32,
   add_special_tokens=True, # Add '[CLS]' and '[SEP]'
   return_token_type_ids=False,
   pad_to_max_length=True,
   return_attention_mask=True,
   return_tensors='pt',  # Return PyTorch tensors
)

print("encoding.keys():")
print(encoding.keys())
print()

print("len(encoding['input_ids'][0]):")
print(len(encoding['input_ids'][0]))
print()

print("encoding['input_ids'][0]:")
print(encoding['input_ids'])
print()

print("len(encoding['attention_mask'][0]):")
print(len(encoding['attention_mask'][0]))
print()

print("encoding['attention_mask']:")
print(encoding['attention_mask'])
print()

print("tokenizer.convert_ids_to_tokens(encoding['input_ids'][0]):")
print(tokenizer.convert_ids_to_tokens(encoding['input_ids'][0]))
print()

