from transformers import pipeline

text_gen = pipeline("text-generation")

# specify a max_length of 50 tokens and sampling "off":
prefix_text = "What a wonderful"
generated_text = text_gen(prefix_text, max_length=50, do_sample=False)[0]

print("=> #1 generated_text['generated_text']:")
print(generated_text['generated_text'])
print("-------------------------------\n")

#output #1:
#What a wonderful thing about this is that it's a very simple and simple way to get your hands on a new game.
#The game is a simple, simple game. It's a simple game. It's a simple game. It's

prefix_text = "Once in a "
generated_text = text_gen(prefix_text, max_length=50, do_sample=False)[0]

print("=> #2 generated_text['generated_text']:")
print(generated_text['generated_text'])
print("-------------------------------\n")

prefix_text = "Once in a blue "
generated_text = text_gen(prefix_text, max_length=50, do_sample=False)[0]

print("=> #3 generated_text['generated_text']:")
print(generated_text['generated_text'])
print("-------------------------------\n")

