# https://stackoverflow.com/questions/12403312/find-the-number-of-spaces-in-a-string
#Given a string find the number of blanks 
#Given a string find the number of non-blanks 
#Given a string find the number of characters 
#Given a string find the number of digits 

str <- "I love deep dish pizza 2day and 3morrow!"
blank_count  = length(gregexpr(" ", str)[[1]])
str_length1  = length(str) 
str_length2  = nchar(str) # also works with numbers 
non_blanks   = str_length2 - blank_count
digit_count1 = nchar(gsub("[^0-9]+", "", str))
digit_count2 = nchar(gsub("\\D", "", str))

print(paste0("Original string:  ",str))
print(paste0("count of blanks:  ",blank_count))
print(paste0("Non-blanks:       ",non_blanks))
print(paste0("String length #1: ",str_length1))
print(paste0("String length #2: ",str_length2))
print(paste0("digit count #1:   ",digit_count1))
print(paste0("digit count #2:   ",digit_count2))

tokens1 = strsplit(str, " ")[[1]]
tokens2 = strsplit(str, " ")
print(paste0("Tokens #1:        ",tokens1))
print(paste0("Tokens #2:        ",tokens2))

