#options(repos=structure(c(CRAN="https://cran.cnr.berkeley.edu/")))
#install.packages("RSQLite")
#install.packages("DBI")
library(RSQLite)
library(DBI)

print("Establishing database connection...")
db = RSQLite::datasetsDb()

# display the tables in the database
print("Reading database tables...")
dbListTables(db)

print("Reading contents of mtcars table...")
dbReadTable(db, "mtcars")

# filter the data
print("Listing rows in the mtcars table...")
dbGetQuery(db, "SELECT * FROM mtcars")

print("Disconnecting database connection...")
dbDisconnect(db)

