# define a sample of 50 values:
x <- sample(1:200, size = 50, replace = TRUE)
print(paste0("mean(x):  ", mean(x)))
print(paste0("min(x):   ", min(x)))
print(paste0("max(x):   ", max(x)))
print(paste0("median(x):", median(x)))

# make a copy of x:
y <- x

# randomly set 10 values to NA:
y[sample(1:50, size=10, replace=TRUE)] <- NA
print("mean of y with NA values:")
print(mean(y, na.rm=TRUE))

# Calculate a weighted mean:
scores  <- c(250, 100, 80, 360)
weights <- c(1/2, 1/4, 1/8, 1/8)
print("scores:")
print(scores)
print("weights:")
print(weights)

wm <- weighted.mean(x=scores, w=weights)
print(paste0("weighted mean: ",wm))

print(paste0("Variance of x: ",var(x)))
print(paste0("STD of y:", sd(y, na.rm=TRUE)))


