import transformers
import numpy as np

# instantiate a BERT tokenizer and model:
print("creating tokenizer...")
tokenizer = transformers.BertTokenizer.from_pretrained('bert-base-uncased', do_lower_case=True)
print("creating model...")
nlp = transformers.TFBertModel.from_pretrained('bert-base-uncased')

# hidden layer with embeddings:
text1      = "cell phone"
input_ids1 = np.array(tokenizer.encode(text1))[None,:]  
embedding1 = nlp(input_ids1)

print("input_ids1:")
print(input_ids1)
print()

print("tokenizer.sep_token:   ",tokenizer.sep_token)
print("tokenizer.sep_token_id:",tokenizer.sep_token_id)
print("tokenizer.cls_token:   ",tokenizer.cls_token)
print("tokenizer.cls_token_id:",tokenizer.cls_token_id)
print("tokenizer.pad_token:   ",tokenizer.pad_token)
print("tokenizer.pad_token_id:",tokenizer.pad_token_id)
print("tokenizer.unk_token:   ",tokenizer.unk_token)
print("tokenizer.unk_token_id:",tokenizer.unk_token_id)
print()

