/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.Timer;

public class GameBoard
extends JFrame
implements MouseMotionListener,
MouseListener,
Drawable {
    boolean timer1On = true;
    int timer1Interval = 1000;
    boolean timer2On = true;
    int timer2Interval = 500;
    boolean timer3On = true;
    int timer3Interval = 250;
    Color backgroundColor = Color.pink;
    static String windowTitle;
    static boolean gameStarted;
    Drawable gamePanel;
    int boardWidth;
    int boardHeight;
    boolean appletPaint = false;
    StartHandler startHandler = new StartHandler();
    StopHandler stopHandler = new StopHandler();
    LeftHandler leftHandler = new LeftHandler();
    RightHandler rightHandler = new RightHandler();
    UpHandler upHandler = new UpHandler();
    DownHandler downHandler = new DownHandler();
    Timer1Handler timer1Handler = new Timer1Handler();
    Timer2Handler timer2Handler = new Timer2Handler();
    Timer3Handler timer3Handler = new Timer3Handler();
    KeyHandler keyBoard = new KeyHandler();
    Timer t1 = new Timer(this.timer1Interval, this.timer1Handler);
    Timer t2 = new Timer(this.timer2Interval, this.timer2Handler);
    Timer t3 = new Timer(this.timer3Interval, this.timer3Handler);
    boolean isStandalone = false;
    BorderLayout borderLayout1 = new BorderLayout();
    JButton startButton = new JButton();
    JButton stopButton = new JButton();
    JButton leftButton = new JButton();
    JButton upButton = new JButton();
    JButton rightButton = new JButton();
    JButton downButton = new JButton();
    Image mImage;
    Image initImage;

    public void repaint(boolean paint) {
        if (paint) {
            this.repaint();
        }
    }

    @Override
    public void draw(Graphics g) {
        this.gamePanel.draw(g);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.appletPaint = false;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        this.gamePanel.mouseDragged(x, y);
        this.appletPaint = false;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        int buttonPressed = me.getButton();
        this.gamePanel.mouseClicked(x, y, buttonPressed);
        this.appletPaint = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.appletPaint = false;
        this.repaint();
    }

    public void setTimerInterval(int timerNumber, int interval) {
        if (timerNumber == 1) {
            this.timer1Interval = interval;
            this.t1.stop();
            this.t1 = new Timer(this.timer1Interval, this.timer1Handler);
            if (gameStarted && this.timer1On) {
                this.t1.start();
            }
        } else if (timerNumber == 2) {
            this.timer2Interval = interval;
            this.t2.stop();
            this.t2 = new Timer(this.timer2Interval, this.timer2Handler);
            if (gameStarted && this.timer2On) {
                this.t2.start();
            }
        } else if (timerNumber == 3) {
            this.timer3Interval = interval;
            this.t3.stop();
            this.t3 = new Timer(this.timer3Interval, this.timer3Handler);
            if (gameStarted && this.timer3On) {
                this.t3.start();
            }
        }
    }

    public void startTimer(int timerNumber) {
        if (timerNumber == 1) {
            this.timer1On = true;
            this.t1.start();
        } else if (timerNumber == 2) {
            this.timer2On = true;
            this.t2.start();
        } else if (timerNumber == 3) {
            this.timer3On = true;
            this.t3.start();
        }
    }

    public void stopTimer(int timerNumber) {
        if (timerNumber == 1) {
            this.t1.stop();
            this.timer1On = false;
        } else if (timerNumber == 2) {
            this.t2.stop();
            this.timer2On = false;
        } else if (timerNumber == 3) {
            this.t3.stop();
            this.timer3On = false;
        }
    }

    public GameBoard(Object ge, String windowTitle, int boardWidthLocal, int boardHeightLocal) {
        super(windowTitle);
        this.gamePanel = (Drawable)ge;
        this.boardWidth = boardWidthLocal;
        this.boardHeight = boardHeightLocal;
        this.setBackground(this.backgroundColor);
        this.setLayout(null);
        this.setDefaultCloseOperation(3);
        this.setSize(this.boardWidth + 122, this.boardHeight + 5);
        this.setLocation(100, 100);
        int upButtonY = (int)((double)this.boardHeight / 2.0);
        this.upButton.setBounds(new Rectangle(this.boardWidth + 39, upButtonY, 44, 22));
        this.upButton.setFont(new Font("Tahoma", 0, 8));
        this.upButton.setText("/\\");
        this.upButton.addActionListener(this.upHandler);
        this.startButton.setBounds(new Rectangle(this.boardWidth + 28, upButtonY - 46, 70, 22));
        this.startButton.setText("Start");
        this.startButton.addActionListener(this.startHandler);
        this.stopButton.setBounds(new Rectangle(this.boardWidth + 28, upButtonY - 24, 70, 22));
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(this.stopHandler);
        this.leftButton.setBounds(new Rectangle(this.boardWidth + 8, upButtonY + 22, 51, 22));
        this.leftButton.setHorizontalAlignment(10);
        this.leftButton.setText("<-");
        this.leftButton.addActionListener(this.leftHandler);
        this.rightButton.setBounds(new Rectangle(this.boardWidth + 59, upButtonY + 22, 51, 22));
        this.rightButton.setHorizontalAlignment(0);
        this.rightButton.setText("->");
        this.rightButton.addActionListener(this.rightHandler);
        this.downButton.setBounds(new Rectangle(this.boardWidth + 37, upButtonY + 44, 51, 22));
        this.downButton.setFont(new Font("Tahoma", 0, 8));
        this.downButton.setText("\\/");
        this.downButton.addActionListener(this.downHandler);
        this.add(this.rightButton);
        this.add(this.leftButton);
        this.add(this.upButton);
        this.add(this.downButton);
        this.add(this.startButton);
        this.add(this.stopButton);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this.keyBoard);
        this.rightButton.setFocusable(false);
        this.leftButton.setFocusable(false);
        this.upButton.setFocusable(false);
        this.downButton.setFocusable(false);
        this.startButton.setFocusable(false);
        this.stopButton.setFocusable(false);
    }

    public GameBoard(Object ge, String windowTitle) {
        super(windowTitle);
        this.gamePanel = (Drawable)ge;
        this.boardWidth = 500;
        this.boardHeight = 500;
        this.setBackground(this.backgroundColor);
        this.setLayout(null);
        this.setDefaultCloseOperation(3);
        this.setSize(this.boardWidth + 122, this.boardHeight + 5);
        this.setLocation(100, 100);
        int upButtonY = (int)((double)this.boardHeight / 2.0);
        this.upButton.setBounds(new Rectangle(this.boardWidth + 39, upButtonY, 44, 22));
        this.upButton.setFont(new Font("Tahoma", 0, 8));
        this.upButton.setText("/\\");
        this.upButton.addActionListener(this.upHandler);
        this.startButton.setBounds(new Rectangle(this.boardWidth + 28, upButtonY - 46, 70, 22));
        this.startButton.setText("Start");
        this.startButton.addActionListener(this.startHandler);
        this.stopButton.setBounds(new Rectangle(this.boardWidth + 28, upButtonY - 24, 70, 22));
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(this.stopHandler);
        this.leftButton.setBounds(new Rectangle(this.boardWidth + 8, upButtonY + 22, 51, 22));
        this.leftButton.setHorizontalAlignment(10);
        this.leftButton.setText("<-");
        this.leftButton.addActionListener(this.leftHandler);
        this.rightButton.setBounds(new Rectangle(this.boardWidth + 59, upButtonY + 22, 51, 22));
        this.rightButton.setHorizontalAlignment(0);
        this.rightButton.setText("->");
        this.rightButton.addActionListener(this.rightHandler);
        this.downButton.setBounds(new Rectangle(this.boardWidth + 37, upButtonY + 44, 51, 22));
        this.downButton.setFont(new Font("Tahoma", 0, 8));
        this.downButton.setText("\\/");
        this.downButton.addActionListener(this.downHandler);
        this.add(this.rightButton);
        this.add(this.leftButton);
        this.add(this.upButton);
        this.add(this.downButton);
        this.add(this.startButton);
        this.add(this.stopButton);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this.keyBoard);
        this.rightButton.setFocusable(false);
        this.leftButton.setFocusable(false);
        this.upButton.setFocusable(false);
        this.downButton.setFocusable(false);
        this.startButton.setFocusable(false);
        this.stopButton.setFocusable(false);
    }

    public void init() {
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.appletPaint) {
            super.paint(g);
        }
        this.checkOffScreenImage();
        Graphics offG = this.mImage.getGraphics();
        offG.setColor(this.getBackground());
        offG.fillRect(4, 30, this.boardWidth, this.boardHeight);
        this.draw(this.mImage.getGraphics());
        g.drawImage(this.mImage, 0, 0, null);
        this.appletPaint = true;
    }

    private void checkOffScreenImage() {
        Dimension d = this.getSize();
        if (this.mImage == null || this.mImage.getWidth(null) != this.boardWidth || this.mImage.getHeight(null) != this.boardHeight + 30) {
            this.mImage = this.createImage(this.boardWidth, this.boardHeight + 30);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void timer1() {
    }

    @Override
    public void timer2() {
    }

    @Override
    public void timer3() {
    }

    @Override
    public void leftButton() {
    }

    @Override
    public void rightButton() {
    }

    @Override
    public void upButton() {
    }

    @Override
    public void downButton() {
    }

    @Override
    public void keyStruck(char key) {
    }

    @Override
    public void mouseClicked(int x, int y, int buttonPressed) {
    }

    @Override
    public void mouseDragged(int x, int y) {
    }

    static {
        gameStarted = false;
    }

    class StopHandler
    implements ActionListener {
        StopHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameBoard.this.t1.stop();
            GameBoard.this.t2.stop();
            GameBoard.this.t3.stop();
        }
    }

    class StartHandler
    implements ActionListener {
        StartHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            gameStarted = true;
            if (GameBoard.this.timer1On) {
                GameBoard.this.t1.start();
            }
            if (GameBoard.this.timer2On) {
                GameBoard.this.t2.start();
            }
            if (GameBoard.this.timer3On) {
                GameBoard.this.t3.start();
            }
            GameBoard.this.appletPaint = true;
            GameBoard.this.repaint();
            GameBoard.this.appletPaint = false;
        }
    }

    class Timer3Handler
    implements ActionListener {
        Timer3Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameBoard.this.gamePanel.timer3();
            GameBoard.this.appletPaint = false;
            GameBoard.this.repaint();
        }
    }

    class Timer2Handler
    implements ActionListener {
        Timer2Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameBoard.this.gamePanel.timer2();
            GameBoard.this.appletPaint = false;
            GameBoard.this.repaint();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            char c = KeyEvent.getKeyText(e.getKeyCode()).charAt(0);
            GameBoard.this.gamePanel.keyStruck(c);
            GameBoard.this.appletPaint = false;
            GameBoard.this.repaint();
        }
    }

    class DownHandler
    implements ActionListener {
        DownHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameBoard.this.gamePanel.downButton();
            GameBoard.this.appletPaint = false;
            GameBoard.this.repaint();
        }
    }

    class UpHandler
    implements ActionListener {
        UpHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameBoard.this.gamePanel.upButton();
            GameBoard.this.appletPaint = false;
            GameBoard.this.repaint();
        }
    }

    class RightHandler
    implements ActionListener {
        RightHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameBoard.this.gamePanel.rightButton();
            GameBoard.this.appletPaint = false;
            GameBoard.this.repaint();
        }
    }

    class LeftHandler
    implements ActionListener {
        LeftHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameBoard.this.gamePanel.leftButton();
            GameBoard.this.appletPaint = false;
            GameBoard.this.repaint();
        }
    }

    class Timer1Handler
    implements ActionListener {
        Timer1Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameBoard.this.gamePanel.timer1();
            GameBoard.this.appletPaint = false;
            GameBoard.this.repaint();
        }
    }
}

