/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Graphics;

public class PongRm
extends DrawableAdapter {
    static PongRm ga = new PongRm();
    static GameBoard gb = new GameBoard(ga, "Pong by Ryan M.");
    static Paddle pLeft;
    static Paddle pRight;
    static Ball ball;
    static int paddleSpeed;
    static int ballSpeed;
    static boolean gameOver;
    static int score;
    static int speedLevel;

    static {
        paddleSpeed = 6;
        ballSpeed = 3;
        gameOver = false;
        score = 0;
        speedLevel = 1;
    }

    public static void main(String[] args) {
        pLeft = new Paddle(50, 200, 100, 20);
        pRight = new Paddle(430, 200, 100, 20);
        ball = new Ball(240, 240, 20, ballSpeed);
        gb.setTimerInterval(3, 30);
        PongRm.showGameBoard(gb);
    }

    @Override
    public void draw(Graphics g) {
        g.setFont(new Font("Arial", 1, 18));
        if (gameOver) {
            gb.stopTimer(1);
            gb.stopTimer(3);
            g.drawString("Game Over", 230, 100);
        }
        g.drawString("Score: " + score, 240, 60);
        g.drawString("Speed Level: " + speedLevel, 220, 80);
        pLeft.show(g);
        pRight.show(g);
        ball.show(g);
    }

    @Override
    public void keyStruck(char key) {
        switch (key) {
            case 'U': {
                pLeft.setY(pLeft.getY() - paddleSpeed);
                pRight.setY(pRight.getY() - paddleSpeed);
                break;
            }
            case 'D': {
                pLeft.setY(pLeft.getY() + paddleSpeed);
                pRight.setY(pRight.getY() + paddleSpeed);
            }
        }
    }

    @Override
    public void timer3() {
        if (ball.getX() > 451 || ball.getX() < 29) {
            gameOver = true;
        }
        if (ball.getY() > 480 || ball.getY() < 30) {
            ball.setYSpeed(-ball.getYSpeed());
        }
        if (ball.getY() + 20 > pLeft.getY() && ball.getY() < pLeft.getY() + 100 && ball.getX() <= pLeft.getX() + 20 && ball.getX() + 20 > pLeft.getX() + 10) {
            ball.setX(ball.getX() + -1 * ball.getXSpeed() / Math.abs(ball.getXSpeed()));
            ball.setXSpeed(-ball.getXSpeed());
            ++score;
        } else if (ball.getY() + 20 > pRight.getY() && ball.getY() < pRight.getY() + 100 && ball.getX() + 20 >= pRight.getX() && ball.getX() <= pRight.getX() + 10) {
            ball.setX(ball.getX() + -1 * ball.getXSpeed() / Math.abs(ball.getXSpeed()));
            ball.setXSpeed(-ball.getXSpeed());
            ++score;
        }
        ball.setY(ball.getY() + ball.getYSpeed());
        ball.setX(ball.getX() + ball.getXSpeed());
    }

    @Override
    public void timer1() {
        if (score != 0 && score % 5 == 0) {
            ball.increaseSpeed(1);
            ++paddleSpeed;
            ++speedLevel;
        }
    }
}

