/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;

public class Asteroid {
    private int x = 150;
    private int y = 170;
    private int xSpeed;
    private int ySpeed;
    private int diameter;
    private boolean visible = true;

    public Asteroid(int x, int yLoc, int diameter) {
        this.x = x;
        this.y = yLoc;
        this.setDiameter(diameter);
        Random xspd = new Random();
        Random yspd = new Random();
        this.xSpeed = xspd.nextInt(3) + 1;
        this.ySpeed = yspd.nextInt(3) + 1;
    }

    public Asteroid() {
    }

    public void show(Graphics g) {
        g.setColor(Color.GRAY);
        g.fillOval(this.x, this.y, this.diameter, this.diameter);
    }

    public void showSC() {
        System.out.println(this.toString());
    }

    public void setX(int newX) {
        this.x = newX;
    }

    public void setXSpeed(int newXSpeed) {
        this.xSpeed = newXSpeed;
    }

    public void setY(int newY) {
        this.y = newY;
    }

    public void setYSpeed(int newYSpeed) {
        this.ySpeed = newYSpeed;
    }

    public int getX() {
        return this.x;
    }

    public int getXSpeed() {
        return this.xSpeed;
    }

    public int getY() {
        return this.y;
    }

    public int getYSpeed() {
        return this.ySpeed;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public boolean collidedWith(Ship ship) {
        if (this.getX() > ship.getX()) {
            return false;
        }
        if (this.getX() + this.diameter < ship.getX()) {
            return false;
        }
        if (this.getY() > ship.getY()) {
            return false;
        }
        return this.getY() + this.diameter >= ship.getY();
    }

    public int getDiameter() {
        return this.diameter;
    }

    public void setDiameter(int diameter) {
        this.diameter = diameter;
    }
}

