from sqlitedict import SqliteDict

# read the contents of my_db.sqlite
# and note no autocommit=True
with SqliteDict('./my_db.sqlite') as mydict:  
  print("old:", mydict['pasta']) 
  mydict['pasta'] = u"more pasta"
  print("new:", mydict['pasta']) 
  mydict['pizza'] = range(10)
  mydict.commit()
  # this is not persisted to disk:
  mydict['dish'] = u"deep dish"

# open the same file again:
with SqliteDict('./my_db.sqlite') as mydict:  
  print("pasta:",mydict['pasta']) 
  # this line will cause an error:
  #print("dish  value:",mydict['dish']) 

