-- https://en.wikipedia.org/wiki/List_of_circulating_currencies

use mytools;
DROP TABLE IF EXISTS currencies;

CREATE TABLE currencies
(   
   curr_id INT NOT NULL AUTO_INCREMENT,
   currency  VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
   curr_name  VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
   PRIMARY KEY (curr_id)
);

INSERT INTO currencies SET curr_name="dollar",currency="$";
INSERT INTO currencies SET curr_name="yen",currency="¥";
INSERT INTO currencies SET curr_name="euro",currency="€";
INSERT INTO currencies SET curr_name="pound",currency="£";
INSERT INTO currencies SET curr_name="rupee",currency="₨";

\! echo '=> All rows in table currencies:';
SELECT * FROM currencies;

