use nlp_samples;
DROP TABLE IF EXISTS nlp_terms;

-- create table:
CREATE TABLE nlp_terms (
          id INT UNSIGNED AUTO_INCREMENT NOT NULL PRIMARY KEY,
          nlp_term VARCHAR(200),
          definition TEXT,
          FULLTEXT (nlp_term,definition)
        ) ENGINE=InnoDB;

-- insert data into table:
INSERT INTO nlp_terms (nlp_term,definition) VALUES
        ('nltk','An NLP toolkit from Stanford...'),
        ('SpaCy','A popular NLP toolkit...'),
        ('stopwords','Common words that do not add meaning...'),
        ('stemming','Truncates word suffixes...'),
        ('lemmatization','Finds the root word of a given word...'),
        ('word2vec','Google algorithm for CBoW and GloVe (Stanford)...');

-- select data:
SELECT * FROM nlp_terms
        WHERE MATCH (nlp_term,definition)
        AGAINST ('NLP' IN NATURAL LANGUAGE MODE);

