use pandas;

DROP PROCEDURE IF EXISTS get_factorial;
DROP PROCEDURE IF EXISTS factorial_recursive;

DELIMITER //
CREATE PROCEDURE get_factorial(IN N INT)
BEGIN
  SET @@GLOBAL.max_sp_recursion_depth = 255;
  SET @@session.max_sp_recursion_depth = 255;
  CALL factorial_recursive (N, @factorial);
  SELECT @factorial;
END //

CREATE PROCEDURE factorial_recursive(IN N INT,OUT factorial INT)
BEGIN
  IF N = 1 THEN
    SET factorial := 1;
  ELSE
    CALL factorial_recursive (N-1, factorial);
    SET factorial := N * factorial;
  END IF;
END //

DELIMITER ;
Call get_factorial(10);
Call get_factorial(5);

