rootdomain() {
    # This function takes a subdomain as input and returns the root domain.
    while IFS= read -r line; do
            echo "$line" | awk -F. '
            {
                n = split($0, parts, ".");
                if (n >= 3 && (parts[n-1] ~ /^(com|net|org|co|gov|edu|mil|int)$/ && parts[n] ~ /^[a-z]{2}$/)) {
                    print parts[n-2] "." parts[n-1] "." parts[n];
                } else if (n >= 2) {
                    print parts[n-1] "." parts[n];
                } else {
                    print $0;
                }
            }'
    done
}
