#!/usr/bin/env bash
pivot_hosts=("user-1@192.168.5.150" "user-2@10.1.0.50" "user-3@172.16.1.25")
target="user-4@192.168.20.200"
local_port=9090
# Set up the pivot chain
for ((i=0; i<${#pivot_hosts[@]}; i++)); do
    next_port=$((local_port + i + 1))
    if [ $i -eq 0 ]; then
        ssh -f -N -L ${local_port}:localhost:${next_port} ${pivot_hosts[$i]}
    elif [ $i -eq $((${#pivot_hosts[@]} - 1)) ]; then
        ssh -f -N -L ${next_port}:${target%@*}:22 ${pivot_hosts[$i]}
    else
        ssh -f -N -L ${next_port}:localhost:$((next_port + 1)) ${pivot_hosts[$i]}
    fi
done
