#!/usr/bin/env bash

# Function to parse a single JSON object
parse_json() {
    local json="$1"
    
    # Extract specific fields
    local timestamp=$(echo "$json" | jq -r '.timestamp')
    local url=$(echo "$json" | jq -r '.url')
    local title=$(echo "$json" | jq -r '.title')
    local webserver=$(echo "$json" | jq -r '.webserver')
    local status_code=$(echo "$json" | jq -r '.status_code')
    
    # Print extracted information
    echo "Timestamp: $timestamp"
    echo "URL: $url"
    echo "Title: $title"
    echo "Web Server: $webserver"
    echo "Status Code: $status_code"
    echo "---"
}

# Read JSON objects line by line
while IFS= read -r line; do
    parse_json "$line"
done
