#!/usr/bin/env bash

# Base64 encoding
evade_base64() {
    echo "echo '$1' | base64 -d | bash"
}

# Hexadecimal encoding
evade_hex() {
    echo "echo -e '$(echo "$1" | od -A n -t x1 | tr -d ' \n')' | bash"
}

# Command substitution
evade_command_substitution() {
    echo "\$(echo '$1')"
}

# Environment variable
evade_env_var() {
    local var_name="VAR_$(openssl rand -hex 4)"
    echo "$var_name='$1'; \$$var_name"
}

# Arithmetic expansion
evade_arithmetic() {
    local chars=$(echo "$1" | sed 's/./&\n/g')
    local result=""
    for char in $chars; do
        ascii=$(printf '%d' "'$char")
        result+='$(('"$ascii"'))'
    done
    echo "echo -e '$result' | tr -d ' ' | xargs -I {} printf '%b' '\\\\$(printf '%03o' {})'"
}

# Sleep to evade time-based detection
evade_sleep() {
    echo "sleep \$((RANDOM % 5 + 1)); $1"
}
