#!/usr/bin/env bash
echo "Checking for AV/EDR presence..."
# Process check
echo "Processes:"
ps aux | grep -E "(av|edr|protect|defend|guard)"

# File system check
echo "Suspicious directories:"
ls -l /opt /etc | grep -E "(av|antivirus|edr|protect)"

# Network connections
echo "Network connections:"
ss -tuln | grep -E "(8080|443|22)"

# Service check
echo "Services:"
systemctl list-units --type=service | grep -E "(av|antivirus|edr)"

# Kernel modules
echo "Kernel modules:"
lsmod | grep -E "(av|edr|protect)"

echo "Enumeration complete."
