#!/usr/bin/env bash
# Array of common EDR telemetry hostnames
edr_hostnames=(
    "*.crowdstrike.com"
    "*.sentinelone.net"
    "*.carbonblack.com"
    "*.cylance.com"
    "*.symantec.com"
    "*.mcafee.com"
    "*.trendmicro.com"
    "*.sophos.com"
    "*.kaspersky.com"
    "*.fireeye.com"
)
# Function to check for EDR connections
check_edr_connections() {
    echo "Checking for EDR connections..."
    for hostname in "${edr_hostnames[@]}"; do
        if ss -tuar | grep -q "$hostname"; then
            echo "Found connection to $hostname"
        fi
    done
}
check_edr_connections

