#!/usr/bin/env bash

# Set build parameters
DESKTOP="gnome"  # Options: gnome, kde, xfce
ARCH="amd64"     # Options: amd64, arm64
VERSION="custom-1.0"
BUILD_TYPE="installer"  # Options: installer, live

# Create custom password configuration
mkdir -p kali-config/common/includes.chroot/etc/live/config
echo 'LIVE_USER_DEFAULT_GROUPS="audio cdrom dialout floppy video plugdev netdev powerdev scanner bluetooth kali"' > kali-config/common/includes.chroot/etc/live/config/user-setup
echo 'LIVE_USER_PASSWORD=kali' >> kali-config/common/includes.chroot/etc/live/config/user-setup

# Launch build with all parameters
./build.sh \
  --verbose \
  --variant ${DESKTOP} \
  --arch ${ARCH} \
  --version ${VERSION} \
  --${BUILD_TYPE}